/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler;

import java.lang.annotation.Annotation;
import org.springframework.util.Assert;
import org.springmodules.validation.bean.conf.loader.annotation.handler.AbstractPropertyValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.Length;
import org.springmodules.validation.bean.conf.loader.annotation.handler.MaxLength;
import org.springmodules.validation.bean.conf.loader.annotation.handler.MinLength;
import org.springmodules.validation.bean.rule.AbstractValidationRule;
import org.springmodules.validation.bean.rule.LengthValidationRule;
import org.springmodules.validation.bean.rule.MaxLengthValidationRule;
import org.springmodules.validation.bean.rule.MinLengthValidationRule;

public class LengthValidationAnnotationHandler
extends AbstractPropertyValidationAnnotationHandler {
    public LengthValidationAnnotationHandler() {
        super(Length.class, MinLength.class, MaxLength.class);
    }

    protected AbstractValidationRule createValidationRule(Annotation annotation, Class clazz, String propertyName) {
        if (Length.class.isInstance(annotation)) {
            Length length = (Length)annotation;
            this.validateMinMax(length.min(), length.max(), clazz, propertyName);
            return new LengthValidationRule(length.min(), length.max());
        }
        if (MinLength.class.isInstance(annotation)) {
            MinLength minLength = (MinLength)annotation;
            this.validateMin(minLength.value(), clazz, propertyName);
            return new MinLengthValidationRule(minLength.value());
        }
        if (MaxLength.class.isInstance(annotation)) {
            MaxLength maxLength = (MaxLength)annotation;
            this.validateMax(maxLength.value(), clazz, propertyName);
            return new MaxLengthValidationRule(maxLength.value());
        }
        throw new IllegalArgumentException("LengthValidationAnnotationHandler does not suppport annotations of type: " + annotation.getClass().getName());
    }

    protected void validateMinMax(int min, int max, Class clazz, String propertyName) {
        Assert.isTrue((max >= 0 ? 1 : 0) != 0, (String)("@Length annotation on property '" + clazz.getName() + "." + propertyName + "' is mal-configured - 'max' attribute cannot hold a negative value"));
        Assert.isTrue((min >= 0 ? 1 : 0) != 0, (String)("@Length annotation on property '" + clazz.getName() + "." + propertyName + "' is mal-configured - 'min' attribute cannot hold a negative value"));
        Assert.isTrue((max >= min ? 1 : 0) != 0, (String)("@Length annotation on property '" + clazz.getName() + "." + propertyName + "' is mal-configured - 'max' attribute is smaller than 'min'"));
    }

    protected void validateMax(int max, Class clazz, String propertyName) {
        Assert.isTrue((max >= 0 ? 1 : 0) != 0, (String)("@Length annotation on property '" + clazz.getName() + "." + propertyName + "' is mal-configured - 'max' attribute cannot hold a negative value"));
    }

    protected void validateMin(int min, Class clazz, String propertyName) {
        Assert.isTrue((min >= 0 ? 1 : 0) != 0, (String)("@Length annotation on property '" + clazz.getName() + "." + propertyName + "' is mal-configured - 'min' attribute cannot hold a negative value"));
    }
}

